appModule.directive("noticeItem", ["$translate", "notices", function (translate, notices) {
    return {
        templateUrl: "templates/notice_item.html",
        restrict: "E",
        scope: {
            convertTime: "&",
            n: "=",
            hideOptions: "@",
            showPreview: "&",
            showPublishScope: "&",
            showPublish: "&",
            forward: "&",
            deleteNotice: "&",
            needShowPublishScope: "&",
            bbsHeight: "@",
            taskHeight: "@",
            showDetailBtn:"="
        },
        link: function ($scope) {
            var stopWatchData = $scope.$watch('n', function (newV, oldV) {
                if (newV) {
                    var dom = $(newV.elements);
                    if (dom.hasClass('bbs')) {
                        dom.css('height',$scope.bbsHeight+'px');
                        dom.find('img').each(function () {
                            var src = $(this).attr('src');
                            $(this).attr('src', notices.modifyImageURL(src, 360));
                        });
                        newV.elements = dom[0].outerHTML;
                    }

                    if (dom.hasClass('task')) {
                        dom.css('height', $scope.taskHeight+'px');
                        newV.elements = dom[0].outerHTML;
                    }
                }
            });

            $scope.$on('$destroy', function () {
                stopWatchData();
            });

            $scope.checkTopic = function(topic){
                if(!topic){
                    return translate.instant("notice.no-topic");
                }

                return topic;
            };
            $scope.checkSummary = function(summary){
                if(!summary){
                    return translate.instant("notice.no-summary");
                }
                return summary;
            };
            $scope.getExpirationText = function () {
                if ($scope.n && $scope.n.ext_data) {
                    if(!$scope.n.needExpiration){
                        return translate.instant('task.detail.no-expired');
                    }else if($scope.n.ext_data.end_time){
                        return translate.instant('publish.task.task-expiration',{date:utils.time2str($scope.n.ext_data.end_time/1000)});
                    }
                }
                return "";
            };
        }
    };
}]);
